ORCA/M Asm65816 2.1.0

0001 3C00                       TITLE 'Reset Service'
0002 3C00
0003 3C00              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 3C00              ;	by EdAsmCvtIIGS version 1.2d8 on 5/16/91 at 9:21:58 PM
0005 3C00
0006 3C00              *****************************************************************
0007 3C00              *                                                               *
0008 3C00              *       This is the main entry point for the Phoenix sony       *
0009 3C00              *       driver. It expects to finds call parameters in page     *
0010 3C00              *       0, starting at address $42.  The number of parameters   *
0011 3C00              *       will vary depending on the type of call.                *
0012 3C00              *                                                               *
0013 3C00              *       ON ENTRY : X-reg = unitno from SmartPort firmware       *
0014 3C00              *                                                               *
0015 3C00              *****************************************************************
0016 3C00              DSONY_ENTRY EQU   *                     ;
0017 3C00 20 DD 46              JSR   regs_setup               ; set up DBR,CYA,/ENBL35, & save X
0018 3C03 9C 51 0F              STZ   mac_flag                 ; reset mac command marker
0019 3C06 A9 A5                 LDA   #$A5
0020 3C08 CD B6 0F              CMP   power1
0021 3C0B F0 0F                 BEQ   warmstart                ; drives ready go to it
0022 3C0D 8D B6 0F              STA   power1                   ;set power1 for next InitCmd 
0023 3C10              *
0024 3C10              * Now, initialize the formatter values and clr the timeout counters
0025 3C10              ;
0026 3C10 20 41 3C              JSR   InitFormat
0027 3C13              *
0028 3C13 20 52 3C              JSR   InitHooks                ;Set the hooks
0029 3C16 20 60 3C              JSR   initmarks                ; set up mark tables
0030 3C19              *
0031 3C19              * Now initialize stuff and locate the drives (eject blanks)
0032 3C19 20 96 47              JSR   configure                ; assign drives which need IDs
0033 3C1C              *
0034 3C1C              * There is the possibility that a reset occurred while an eject was
0035 3C1C              *  in progress.  Some drives will fail in this case.  In an attempt
0036 3C1C              *  to minimize the risk, we retry the eject if it was interrupted.
0037 3C1C              *
0038 3C1C              WARMSTART EQU   *
0039 3C1C 2C 56 0F              BIT   MidEject                 ;The flag is now in N bit
0040 3C1F 30 0C                 BMI   reset1                   ;If hi, forget it
0041 3C21 AE 56 0F              LDX   mideject                 ;This has the drive number
0042 3C24 8E 28 0F              STX   drive                    ;this occurs before Vector sets drive
0043 3C27 20 C3 49              JSR   EnblDrivX
0044 3C2A 20 AE 48              JSR   Eject                    ;Try again
0045 3C2D              RESET1   EQU   *
0046 3C2D              ************************************************************
0047 3C2D              *                                                          *
0048 3C2D              * mainline                                 Top level loop  *
0049 3C2D              *                                                          *
0050 3C2D              *   This is the driving force behind the operation of the  *
0051 3C2D              * firmware.  It does three things- gets a command from     *
0052 3C2D              * the host, services the command, and returns the status.  *
0053 3C2D              *                                                          *
0054 3C2D              ************************************************************
0055 3C2D              MAINLINE EQU   *
0056 3C2D              *
0057 3C2D              * Jump to the appropriate service routine.  Set status bytes.
0058 3C2D 20 5A 3E              JSR   vector
0059 3C30              *
0060 3C30              * return to caller with a status
0061 3C30 2C E8 C0              BIT   DeSelect                 ; start drive's timer
0062 3C33 9C 31 C0              STZ   diskreg                  ; remove /ENBL3.5
0063 3C36 18                    CLC   
0064 3C37 AD 4B 0F              LDA   statbyte                 ;
0065 3C3A 8D 10 0F              STA   stssav-2                 ;save error status for dbug
0066 3C3D F0 01                 BEQ   all_done                 ; go home
0067 3C3F 38                    SEC                            ; something wrong, flag it.
0068 3C40 60           ALL_DONE RTS   
0069 3C41              *
0070 3C41                       TITLE 'ColdStart Initializations'
0071 3C41              ****************************************************
0072 3C41              INITFORMAT EQU   *
0073 3C41 A9 04                 LDA   #XLeaveDef
0074 3C43 8D 4F 0F              STA   Interleave
0075 3C46 A9 80                 LDA   #$80                     ;Double sided drives default
0076 3C48 8D 50 0F              STA   formsides
0077 3C4B 9C 52 0F              STZ   FmtOption
0078 3C4E 9C 53 0F              STZ   FmtOption+1
0079 3C51 60                    RTS   
0080 3C52              *
0081 3C52              *
0082 3C52              INITHOOKS EQU   *
0083 3C52 A2 41                 LDX   #HookTabLen+1
0084 3C54 BF 02 3E FF  RST2     LDA   >HookTab,x
0085 3C58 9F 6D 0F E1           STA   Hooks,x
0086 3C5C CA                    DEX   
0087 3C5D 10 F5                 BPL   rst2
0088 3C5F 60                    RTS                            ; >>>--- exit Inithooks --->>>
0089 3C60              ;
0090 3C60              *
0091 3C60              INITMARKS EQU   *                       ;
0092 3C60 A2 15                 LDX   #MarkTabLen-1
0093 3C62 BF 44 3E FF  RST3     LDA   >MarkTabVals,x
0094 3C66 9D 57 0F              STA   MarkTab,x
0095 3C69 CA                    DEX   
0096 3C6A 10 F6                 BPL   rst3
0097 3C6C 60                    RTS   
0098 3C6D              *
0099 3C6D              *
0100 3C6D A9 28        NO_DRIVES LDA   #nodrverr               ; no drive connected
0101 3C6F 38           SET_ERR  SEC                            ; return with error status
0102 3C70 8D 4B 0F              STA   statbyte                 ; save the status
0103 3C73 60                    RTS   
0104 3C74              ;
0105 3C74              ;
0106 3C74                       TITLE 'wait table for timers'
0107 3C74                                                      ; SEG	code	;
0108 3C74 19 19 19 19  FMTWTAB  DC B:25,25,25,25,150
0109 3C79              *
0110 3C79              VOLSIZETBL EQU   *
0111 3C79 00 00                 DC W:0000                      ;0 = unknown
0112 3C7B 20 03                 DC W:0800                      ;2 = 400K 
0113 3C7D 40 06                 DC W:1600                      ;4 = 800K 4:1
0114 3C7F A0 05                 DC W:1440                      ;6 = reserved
0115 3C81 A0 05                 DC W:1440                      ;8 = 720K 
0116 3C83 40 0B                 DC W:2880                      ;A = 1440K MFM 2:1
0117 3C85 40 06                 DC W:1600                      ;C = 800K 2:1 
0118 3C87                                                      ; SEG	fake_it
0119 3C87              *
0120 3C87                       TITLE 'Denibbilizing Table'
0121 3C87              ******************************************************
0122 3C87              *                                                    *
0123 3C87              *          7 bit to 6 bit 'Deniblize' Table          *
0124 3C87              *                                                    *
0125 3C87              *          Valid codes are $96 to $FF only           *
0126 3C87              *     Codes with more than one pair of adjacent      *
0127 3C87              *      zeroes or with no adjacent ones (except       *
0128 3C87              *               bit 7) are excluded.                 *
0129 3C87              *                                                    *
0130 3C87              *      This table *must* be aligned at the end       *
0131 3C87              *               of a page in memory.                 *
0132 3C87              *                                                    *
0133 3C87              ******************************************************
0134 3C87                                                      ; SEG	code	; rom bank
0135 3C87              XB       EQU   (*-Rel~Org+Bnk~Org)**$00FF ;
0136 3C87              *
0137 3C87 00 00 00 00           DC B:$96-XB,0                  	;Pad up to $XX96 
0138 3C96              DNIBTAB  EQU   *-$96
0139 3C96              *
0140 3C96 00 01 98              DC B:$00,$01,$98
0141 3C99 99 02 03              DC B:$99,$02,$03
0142 3C9C 9C 04 05              DC B:$9C,$04,$05
0143 3C9F 06 A0 A1              DC B:$06,$A0,$A1
0144 3CA2 A2 A3 A4              DC B:$A2,$A3,$A4
0145 3CA5 A5 07 08              DC B:$A5,$07,$08
0146 3CA8 A8 A9 AA              DC B:$A8,$A9,$AA
0147 3CAB 09 0A 0B              DC B:$09,$0A,$0B
0148 3CAE 0C 0D B0              DC B:$0C,$0D,$B0
0149 3CB1 B1 0E 0F              DC B:$B1,$0E,$0F
0150 3CB4 10 11 12              DC B:$10,$11,$12
0151 3CB7 13 B8 14              DC B:$13,$B8,$14
0152 3CBA 15 16 17              DC B:$15,$16,$17
0153 3CBD 18 19 1A              DC B:$18,$19,$1A
0154 3CC0 C0 C1 C2              DC B:$C0,$C1,$C2
0155 3CC3 C3 C4 C5              DC B:$C3,$C4,$C5
0156 3CC6 C6 C7 C8              DC B:$C6,$C7,$C8
0157 3CC9 C9 CA 1B              DC B:$C9,$CA,$1B
0158 3CCC CC 1C 1D              DC B:$CC,$1C,$1D
0159 3CCF 1E D0 D1              DC B:$1E,$D0,$D1
0160 3CD2 D2 1F D4              DC B:$D2,$1F,$D4
0161 3CD5 D5 20 21              DC B:$D5,$20,$21
0162 3CD8 D8 22 23              DC B:$D8,$22,$23
0163 3CDB 24 25 26              DC B:$24,$25,$26
0164 3CDE 27 28 E0              DC B:$27,$28,$E0
0165 3CE1 E1 E2 E3              DC B:$E1,$E2,$E3
0166 3CE4 E4 29 2A              DC B:$E4,$29,$2A
0167 3CE7 2B E8 2C              DC B:$2B,$E8,$2C
0168 3CEA 2D 2E 2F              DC B:$2D,$2E,$2F
0169 3CED 30 31 32              DC B:$30,$31,$32
0170 3CF0 F0 F1 33              DC B:$F0,$F1,$33
0171 3CF3 34 35 36              DC B:$34,$35,$36
0172 3CF6 37 38 F8              DC B:$37,$38,$F8
0173 3CF9 39 3A 3B              DC B:$39,$3A,$3B
0174 3CFC 3C 3D 3E              DC B:$3C,$3D,$3E
0175 3CFF 3F                    DC B:$3F
0176 3D00              ;
0177 3D00              ;
0178 3D00                                                      ; SEG	fake_it	; make code run in bank $00
0179 3D00                       TITLE 'Nibble Table'
0180 3D00              ******************************************************
0181 3D00              *                                                    *
0182 3D00              *           6 bit to 7 bit 'Niblize' Table           *
0183 3D00              *                                                    *
0184 3D00              *          Valid codes are $96 to $FF only           *
0185 3D00              *     Codes with more than one pair of adjacent      *
0186 3D00              *      zeroes or with no adjacent ones (except       *
0187 3D00              *               bit 7) are excluded.                 *
0188 3D00              *                                                    *
0189 3D00              ******************************************************
0190 3D00                                                      ; SEG	code
0191 3D00              NIBTAB   EQU   *
0192 3D00 96 97 9A              DC B:$96,$97,$9A
0193 3D03 9B 9D 9E              DC B:$9B,$9D,$9E
0194 3D06 9F A6 A7              DC B:$9F,$A6,$A7
0195 3D09 AB AC AD              DC B:$AB,$AC,$AD
0196 3D0C AE AF B2              DC B:$AE,$AF,$B2
0197 3D0F B3 B4 B5              DC B:$B3,$B4,$B5
0198 3D12 B6 B7 B9              DC B:$B6,$B7,$B9
0199 3D15 BA BB BC              DC B:$BA,$BB,$BC
0200 3D18 BD BE BF              DC B:$BD,$BE,$BF
0201 3D1B CB CD CE              DC B:$CB,$CD,$CE
0202 3D1E CF D3 D6              DC B:$CF,$D3,$D6
0203 3D21 D7 D9 DA              DC B:$D7,$D9,$DA
0204 3D24 DB DC DD              DC B:$DB,$DC,$DD
0205 3D27 DE DF E5              DC B:$DE,$DF,$E5
0206 3D2A E6 E7 E9              DC B:$E6,$E7,$E9
0207 3D2D EA EB EC              DC B:$EA,$EB,$EC
0208 3D30 ED EE EF              DC B:$ED,$EE,$EF
0209 3D33 F2 F3 F4              DC B:$F2,$F3,$F4
0210 3D36 F5 F6 F7              DC B:$F5,$F6,$F7
0211 3D39 F9 FA FB              DC B:$F9,$FA,$FB
0212 3D3C FC FD FE              DC B:$FC,$FD,$FE
0213 3D3F FF                    DC B:$FF
0214 3D40              *
0215 3D40 96 97 9A              DC B:$96,$97,$9A
0216 3D43 9B 9D 9E              DC B:$9B,$9D,$9E
0217 3D46 9F A6 A7              DC B:$9F,$A6,$A7
0218 3D49 AB AC AD              DC B:$AB,$AC,$AD
0219 3D4C AE AF B2              DC B:$AE,$AF,$B2
0220 3D4F B3 B4 B5              DC B:$B3,$B4,$B5
0221 3D52 B6 B7 B9              DC B:$B6,$B7,$B9
0222 3D55 BA BB BC              DC B:$BA,$BB,$BC
0223 3D58 BD BE BF              DC B:$BD,$BE,$BF
0224 3D5B CB CD CE              DC B:$CB,$CD,$CE
0225 3D5E CF D3 D6              DC B:$CF,$D3,$D6
0226 3D61 D7 D9 DA              DC B:$D7,$D9,$DA
0227 3D64 DB DC DD              DC B:$DB,$DC,$DD
0228 3D67 DE DF E5              DC B:$DE,$DF,$E5
0229 3D6A E6 E7 E9              DC B:$E6,$E7,$E9
0230 3D6D EA EB EC              DC B:$EA,$EB,$EC
0231 3D70 ED EE EF              DC B:$ED,$EE,$EF
0232 3D73 F2 F3 F4              DC B:$F2,$F3,$F4
0233 3D76 F5 F6 F7              DC B:$F5,$F6,$F7
0234 3D79 F9 FA FB              DC B:$F9,$FA,$FB
0235 3D7C FC FD FE              DC B:$FC,$FD,$FE
0236 3D7F FF                    DC B:$FF
0237 3D80              *
0238 3D80 96 97 9A              DC B:$96,$97,$9A
0239 3D83 9B 9D 9E              DC B:$9B,$9D,$9E
0240 3D86 9F A6 A7              DC B:$9F,$A6,$A7
0241 3D89 AB AC AD              DC B:$AB,$AC,$AD
0242 3D8C AE AF B2              DC B:$AE,$AF,$B2
0243 3D8F B3 B4 B5              DC B:$B3,$B4,$B5
0244 3D92 B6 B7 B9              DC B:$B6,$B7,$B9
0245 3D95 BA BB BC              DC B:$BA,$BB,$BC
0246 3D98 BD BE BF              DC B:$BD,$BE,$BF
0247 3D9B CB CD CE              DC B:$CB,$CD,$CE
0248 3D9E CF D3 D6              DC B:$CF,$D3,$D6
0249 3DA1 D7 D9 DA              DC B:$D7,$D9,$DA
0250 3DA4 DB DC DD              DC B:$DB,$DC,$DD
0251 3DA7 DE DF E5              DC B:$DE,$DF,$E5
0252 3DAA E6 E7 E9              DC B:$E6,$E7,$E9
0253 3DAD EA EB EC              DC B:$EA,$EB,$EC
0254 3DB0 ED EE EF              DC B:$ED,$EE,$EF
0255 3DB3 F2 F3 F4              DC B:$F2,$F3,$F4
0256 3DB6 F5 F6 F7              DC B:$F5,$F6,$F7
0257 3DB9 F9 FA FB              DC B:$F9,$FA,$FB
0258 3DBC FC FD FE              DC B:$FC,$FD,$FE
0259 3DBF FF                    DC B:$FF
0260 3DC0              *
0261 3DC0 96 97 9A              DC B:$96,$97,$9A
0262 3DC3 9B 9D 9E              DC B:$9B,$9D,$9E
0263 3DC6 9F A6 A7              DC B:$9F,$A6,$A7
0264 3DC9 AB AC AD              DC B:$AB,$AC,$AD
0265 3DCC AE AF B2              DC B:$AE,$AF,$B2
0266 3DCF B3 B4 B5              DC B:$B3,$B4,$B5
0267 3DD2 B6 B7 B9              DC B:$B6,$B7,$B9
0268 3DD5 BA BB BC              DC B:$BA,$BB,$BC
0269 3DD8 BD BE BF              DC B:$BD,$BE,$BF
0270 3DDB CB CD CE              DC B:$CB,$CD,$CE
0271 3DDE CF D3 D6              DC B:$CF,$D3,$D6
0272 3DE1 D7 D9 DA              DC B:$D7,$D9,$DA
0273 3DE4 DB DC DD              DC B:$DB,$DC,$DD
0274 3DE7 DE DF E5              DC B:$DE,$DF,$E5
0275 3DEA E6 E7 E9              DC B:$E6,$E7,$E9
0276 3DED EA EB EC              DC B:$EA,$EB,$EC
0277 3DF0 ED EE EF              DC B:$ED,$EE,$EF
0278 3DF3 F2 F3 F4              DC B:$F2,$F3,$F4
0279 3DF6 F5 F6 F7              DC B:$F5,$F6,$F7
0280 3DF9 F9 FA FB              DC B:$F9,$FA,$FB
0281 3DFC FC FD FE              DC B:$FC,$FD,$FE
0282 3DFF FF                    DC B:$FF
0283 3E00                                                      ; SEG	fake_it
0284 3E00              ;
0285 3E00                       TITLE ' Hook & Mark tables'
0286 3E00              *
0287 3E00              * Hook Table Initial Values
0288 3E00              *
0289 3E00                                                      ; SEG	code	; force bank
0290 3E00 AB 6B                 DC B:$AB,$6B
0291 3E02              HOOKTAB  EQU   *
0292 3E02 40 00                 DC W:HOOKTABLEN                ;There are this many bytes
0293 3E04 5C 53 4C FF           JMP   >RdAddr~GCR
0294 3E08 5C 53 4C FF           JMP   >RdAddr~GCR
0295 3E0C 5C DD 4C FF           JMP   >ReadData~GCR
0296 3E10 5C DD 4C FF           JMP   >ReadData~GCR
0297 3E14 5C 30 50 FF           JMP   >WriteData~GCR
0298 3E18 5C 30 50 FF           JMP   >WriteData~GCR
0299 3E1C 5C 2A 48 FF           JMP   >Seek+4
0300 3E20 5C 2A 48 FF           JMP   >Seek+4
0301 3E24 5C 27 41 FF           JMP   >Format~Vol
0302 3E28 5C 27 41 FF           JMP   >Format~Vol
0303 3E2C 5C 97 41 FF           JMP   >WriteTrk~GCR
0304 3E30 5C 97 41 FF           JMP   >WriteTrk~GCR
0305 3E34 5C 66 43 FF           JMP   >Verify~GCR
0306 3E38 5C 66 43 FF           JMP   >Verify~GCR
0307 3E3C 5C 5E 3E FF           JMP   >Vector+4
0308 3E40 5C 5E 3E FF           JMP   >Vector+4
0309 3E44              *
0310 3E44              MARKTABVALS EQU   *                     ;Address, data mark table
0311 3E44 FF                    DC B:$FF                       ;Data sector nibble
0312 3E45 AD AA D5 FF           DC B:$AD,$AA,$D5,$FF
0313 3E49 FC F3 CF 3F           DC B:$FC,$F3,$CF,$3F,$FF
0314 3E4E FF                    DC B:$FF
0315 3E4F AA                    DC B:$AA
0316 3E50 DE                    DC B:$DE
0317 3E51 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF
0318 3E56 96 AA D5 FF           DC B:$96,$AA,$D5,$FF
0319 3E5A              *
0320 3E5A                                                      ; SEG	fake_it
0321 3E5A              *
0322 3E5A                       TITLE 'Command Code Vector Routine'
0323 3E5A              ************************************************************
0324 3E5A              *                                                          *
0325 3E5A              *  vector                 Multi-way branch on the cmdcode  *
0326 3E5A              *                                                          *
0327 3E5A              *   This routine looks at the command type byte in the     *
0328 3E5A              *  command table and if it is not a legal code sets the    *
0329 3E5A              *  illegal command status bit.  Otherwise control is       *
0330 3E5A              *  transferred to the routine which supports the command.  *
0331 3E5A              *  Just before vectoring, this routine clears the status.  *
0332 3E5A              *                                                          *
0333 3E5A              *  Input:   cmdcode                                        *
0334 3E5A              *  Regs:    A,X destroyed                                  *
0335 3E5A              *           Y   preserved                                  *
0336 3E5A              *           error1 altered if cmdcode error                *
0337 3E5A              *  Time:    166 microseconds (maximum)                     *
0338 3E5A              *                                                          *
0339 3E5A              ************************************************************
0340 3E5A                                                      ; SEG	code
0341 3E5A              VECTOR   EQU   *
0342 3E5A                                                      ; SEG	fake_it	;
0343 3E5A 5C A7 0F E1           JMP   VectorHook
0344 3E5E              *
0345 3E5E              * If there are drive IDs to assign, skip the drive selection
0346 3E5E              *
0347 3E5E A5 45                 LDA   Cmdcode
0348 3E60 C9 05                 CMP   #cmdDefID                ;init command?
0349 3E62 F0 17                 BEQ   @10                      ;yes. don;t check unit number
0350 3E64              *
0351 3E64              * Decide which drive is meant
0352 3E64              *
0353 3E64 A2 00                 LDX   #00
0354 3E66 A5 4E                 LDA   cmdUnit
0355 3E68 DD 20 0F     @01      CMP   UnitId,x
0356 3E6B F0 0B                 BEQ   @03
0357 3E6D E8                    INX   
0358 3E6E E0 02                 CPX   #maxdrivs
0359 3E70 90 F6                 BCC   @01
0360 3E72              *
0361 3E72 A9 11                 LDA   #$11                     ;bad unit error
0362 3E74 8D 4B 0F              STA   statbyte
0363 3E77 60                    RTS   
0364 3E78 8E 28 0F     @03      STX   drive                    ;define drive to use
0365 3E7B              *
0366 3E7B              * Clear out the status area if NOT a status call
0367 3E7B              *
0368 3E7B A5 45        @10      LDA   CMDCode
0369 3E7D F0 08                 BEQ   skipclrsb
0370 3E7F A2 06                 LDX   #6
0371 3E81 9E 43 0F     VEC1     STZ   statustab,x
0372 3E84 CA                    DEX   
0373 3E85 10 FA                 BPL   vec1
0374 3E87              *
0375 3E87              * Set up the length of the default status string (=0) and statbyte
0376 3E87              *
0377 3E87              SKIPCLRSB EQU   *
0378 3E87 9C 4B 0F              STZ   statbyte                 ; clear status byte
0379 3E8A              *
0380 3E8A              * Okay, now multi-way branch
0381 3E8A              *
0382 3E8A A5 45                 LDA   CMDCode
0383 3E8C C9 0D                 CMP   #ncommands
0384 3E8E 90 05                 BLT   cmdokay
0385 3E90              *
0386 3E90              * Command code was not within legal bounds. Flag as an error
0387 3E90              *
0388 3E90              ILLCMDCODE EQU   *
0389 3E90 A9 01                 LDA   #cmderror
0390 3E92 82 DA FD              BRL   set_err                  ; mark an error
0391 3E95              *
0392 3E95              CMDOKAY  EQU   *
0393 3E95 AA                    TAX   
0394 3E96 BF C6 3E FF           LDA   >parmctab,x
0395 3E9A 29 7F                 AND   #%01111111               ;Strip Top bit
0396 3E9C C5 46                 CMP   CMDPCount
0397 3E9E F0 05                 BEQ   goforit
0398 3EA0              *
0399 3EA0              FLAGPCERR EQU   *
0400 3EA0 A9 04                 LDA   #PCountErr
0401 3EA2 82 CA FD              BRL   set_err                  ; mark an error
0402 3EA5              *
0403 3EA5              GOFORIT  EQU   *
0404 3EA5 8A                    TXA                            ;CMDCode is still in X
0405 3EA6 0A                    ASL   a                        ;Convert to word index 
0406 3EA7 AA                    TAX   
0407 3EA8 7C AC 3E              JMP   (fntable,x)              ; Vector to the routine
0408 3EAB              CLOSERTS EQU   *                        ;
0409 3EAB 60                    RTS                            ; Vector to the routine
0410 3EAC              *
0411 3EAC                                                      ; SEG	code	;
0412 3EAC D4 3E        FNTABLE  DC W:STATUS
0413 3EAE C7 3F                 DC W:READBLK
0414 3EB0 CA 3F                 DC W:WRITEBLK
0415 3EB2 23 41                 DC W:FORMATVOL
0416 3EB4 01 45                 DC W:CONTROL
0417 3EB6 49 45                 DC W:INITCMD
0418 3EB8 90 3E                 DC W:ILLCMDCODE                ;No opens
0419 3EBA 90 3E                 DC W:ILLCMDCODE                ;No Closes
0420 3EBC 6D 45                 DC W:MACREAD                   ;Read nnnn bytes
0421 3EBE 7E 45                 DC W:MACWRITE                  ;Write nnnn bytes
0422 3EC0 8A 44                 DC W:SETFMTOPT                 ;Set Format Options
0423 3EC2 97 43                 DC W:GETFMTOPT                 ;Get Format Options
0424 3EC4 41 51                 DC W:RAWREAD                   ;Raw Track Read
0425 3EC6              *
0426 3EC6              NCOMMANDS EQU   (*-FNTABLE)/2
0427 3EC6              *
0428 3EC6              PARMCTAB EQU   *
0429 3EC6 03                    DC B:%00000011                 ;Status:  3 parms/no data send
0430 3EC7 03                    DC B:%00000011                 ;Read:    3 parms/no data send
0431 3EC8 83                    DC B:%10000011                 ;Write:   3 parms/data send
0432 3EC9 01                    DC B:%00000001                 ;Format:  1 parm /no data send
0433 3ECA 83                    DC B:%10000011                 ;Control: 3 parms/data send
0434 3ECB 02                    DC B:%00000010                 ;Init:    2 parm /no data send
0435 3ECC 01                    DC B:%00000001                 ;Open: not used
0436 3ECD 01                    DC B:%00000001                 ;Close: not used
0437 3ECE 04                    DC B:%00000100                 ;CharRead: 4 parms/data send
0438 3ECF 84                    DC B:%10000100                 ;CharWrite: 4 parms/data send
0439 3ED0 03                    DC B:%00000011                 ;SetFmtOpt
0440 3ED1 03                    DC B:%00000011                 ;GetFmtOpt
0441 3ED2 04                    DC B:%00000100                 ;RawRead
0442 3ED3 02                    DC B:%00000010                 ;filler for t&rf
0443 3ED4                                                      ; SEG	fake_it	;
0444 3ED4                       TITLE 'Status Request Handler'
0445 3ED4              ****************************************************************
0446 3ED4              *                                                              *
0447 3ED4              *  Status                        Handles a status request      *
0448 3ED4              *                                                              *
0449 3ED4              ****************************************************************
0450 3ED4              STATUS   EQU   *
0451 3ED4 A5 48                 LDA   CMDSCode                 ;Get the control code
0452 3ED6 C9 08                 CMP   #nscodes                 ;Check for boundary
0453 3ED8 90 03                 BLT   statokay                 ;It's within range
0454 3EDA              *
0455 3EDA 82 2A 06              BRL   IllCode
0456 3EDD              *
0457 3EDD              * Code is okay... do the multi-way branch
0458 3EDD              *
0459 3EDD              STATOKAY EQU   *
0460 3EDD 0A                    ASL   a
0461 3EDE AA                    TAX   
0462 3EDF BF F0 3E FF           LDA   >sctable+1,x
0463 3EE3 48                    PHA   
0464 3EE4 BF EF 3E FF           LDA   >sctable,x
0465 3EE8 48                    PHA   
0466 3EE9 AE 28 0F              LDX   drive
0467 3EEC 64 5F                 STZ   stsmotor                 ;assume timer cancel mode
0468 3EEE 60                    RTS                            ; go to the routine called
0469 3EEF              *
0470 3EEF                                                      ; SEG	code	;
0471 3EEF              SCTABLE  EQU   *
0472 3EEF 49 3F                 DC W:BASICSTAT-1
0473 3EF1 06 45                 DC W:ILLCODE-1
0474 3EF3 06 45                 DC W:ILLCODE-1                 ;Char dev only
0475 3EF5 FE 3E                 DC W:STATDIB-1
0476 3EF7 06 45                 DC W:ILLCODE-1
0477 3EF9 37 3F                 DC W:STATDEV-1
0478 3EFB A6 46                 DC W:GET_VARS-1                ; variable area dump
0479 3EFD C6 46                 DC W:GET_BUFF_ADDR-1           ; buffers address dump
0480 3EFF              *
0481 3EFF              STATTEND EQU   *
0482 3EFF              NSCODES  EQU   (STATTEND-SCTABLE)/2
0483 3EFF                                                      ; SEG	fake_it	;
0484 3EFF              *
0485 3EFF              *
0486 3EFF              STATDIB  EQU   *
0487 3EFF 20 4A 3F              JSR   BasicStat                ;Sets first four bytes
0488 3F02              *
0489 3F02 9B                    TXY                            ; get current number of bytes
0490 3F03 A2 00                 LDX   #00                      ;Get length of additional data
0491 3F05              SDMORE   EQU   *
0492 3F05 BF 23 3F FF           LDA   >DIBString,x
0493 3F09 97 42                 STA   [cmdbuffl],y             ; save device name
0494 3F0B C8                    INY                            ;
0495 3F0C E8                    INX                            ; bump index
0496 3F0D E0 15                 CPX   #DIBSLen                 ; moved all bytes
0497 3F0F 90 F4                 BCC   sdmore                   ; keep going until all bytes moved
0498 3F11 BB                    TYX                            ; save byte count transfered
0499 3F12 2C 1E 0F              BIT   ext_flag
0500 3F15 10 09                 BPL   @10
0501 3F17 88                    DEY   
0502 3F18 88                    DEY   
0503 3F19 88                    DEY                            ;bak up to devsubtype offset
0504 3F1A B7 42                 LDA   [cmdbuffl],y
0505 3F1C 09 01                 ORA   #01
0506 3F1E 97 42                 STA   [cmdbuffl],y             ;set the SuperCmds bit 
0507 3F20 A0 00        @10      LDY   #00
0508 3F22 60                    RTS   
0509 3F23              *
0510 3F23                                                      ; SEG	code	;
0511 3F23              DIBSTRING EQU   *
0512 3F23 08                    DC B:IDSL
0513 3F24 44 49 53 4B  IDSTRING DC B:'DISK 3.5'
0514 3F2C              *
0515 3F2C              IDSL     EQU   *-IDSTRING               ;ID string length
0516 3F2C              *
0517 3F2C 20 20 20 20           DC B:16-IDSL,$20               ;Pad with spaces
0518 3F34 01                    DC B:DEVTYPE
0519 3F35 C0                    DC B:DEVSUBTYPE
0520 3F36 00 30                 DC W:VERSION
0521 3F38              *
0522 3F38              DIBSLEN  EQU   *-DIBSTRING              ;This is the entire DIB length
0523 3F38                                                      ; SEG	fake_it	;
0524 3F38              *
0525 3F38              *
0526 3F38              STATDEV  EQU   *
0527 3F38 A0 08                 LDY   #nsbytes                 ; copy status table to users buffer
0528 3F3A B9 43 0F     SDLOOP   LDA   statustab,y              ;
0529 3F3D 97 42                 STA   [cmdbuffl],y             ;
0530 3F3F 88                    DEY                            ;
0531 3F40 10 F8                 BPL   sdloop                   ;
0532 3F42 9C 4B 0F              STZ   statbyte
0533 3F45 A2 09                 LDX   #09
0534 3F47 82 70 00              BRL   stat_exit
0535 3F4A              ******************************************************
0536 3F4A              *
0537 3F4A              ******************************************************
0538 3F4A              BASICSTAT EQU   *
0539 3F4A 9C 4B 0F              STZ   statbyte                 ;clear error code
0540 3F4D 20 CF 49              JSR   EnblnSens                ;enable drive and sense status
0541 3F50
0542 3F50 08                    PHP   
0543 3F51 A9 20                 LDA   #VSwrprot
0544 3F53 3D 3E 0F              AND   volsts,x
0545 3F56 4A                    LSR   a
0546 3F57 4A                    LSR   a
0547 3F58 4A                    LSR   a
0548 3F59 09 E8                 ORA   #$E8
0549 3F5B 70 02                 BVS   @10
0550 3F5D 09 10                 ORA   #svmask1                 ;assert online
0551 3F5F 28           @10      PLP   
0552 3F60 08                    PHP   
0553 3F61 30 07                 BMI   @15                      ;disk was ejected
0554 3F63 70 0C                 BVS   @20                      ;offline so skip this
0555 3F65 2C 4C 0F              BIT   priorsts                 ;is this an offline/online transition?
0556 3F68 50 07                 BVC   @20                      ;no. otherwise signal 'switched'
0557 3F6A 2C 1E 0F     @15      BIT   ext_flag
0558 3F6D 50 02                 BVC   @20
0559 3F6F 09 01                 ORA   #svmask3                 ;add in dsw
0560 3F71              @20      EQU   *
0561 3F71 8D 11 0F              STA   stssav-1                 ;save where analyzer can see it
0562 3F74 87 42                 STA   [cmdbuffl]               ;Store the device status byte
0563 3F76              *
0564 3F76              * Now I may need to process a volume type change before
0565 3F76              * I can know how many block are on the new volume
0566 3F76 28                    PLP                            ;do I have a volume
0567 3F77 50 08                 BVC   @30                      ;online volume present
0568 3F79 20 7F 4A              JSR   OfflineX                 ;set volsts to offline&unknown
0569 3F7C 20 4C 4A              JSR   ClearDSW
0570 3F7F 80 12                 BRA   @50                      ;return zero block count
0571 3F81 10 06        @30      BPL   @40                      ;DIP true and DSW false! 
0572 3F83 20 87 4A              JSR   UnkVolx                  ;mark voltype unknown
0573 3F86 20 4C 4A              JSR   ClearDSW
0574 3F89 BD 3E 0F     @40      LDA   volsts,x
0575 3F8C 29 1F                 AND   #$1F                     ;is voltyp known?
0576 3F8E D0 0B                 BNE   @60                      ;yes. so I am all setup
0577 3F90 20 68 47     @45      JSR   mountvol                 ;set VOLTYP if I can 
0578 3F93              @50      EQU   *
0579 3F93 AE 28 0F              LDX   drive                    ;Whichever drive...
0580 3F96 BD 3E 0F              LDA   volsts,x                 ;a=zero if voltype is unknown
0581 3F99 29 1F                 AND   #$1F                     ;extract voltype index
0582 3F9B AA           @60      TAX   
0583 3F9C BF 79 3C FF           LDA   >volsizetbl,x            ;return volsize zero
0584 3FA0 A0 01                 LDY   #01
0585 3FA2 97 42                 STA   [cmdbuffl],y             ;
0586 3FA4 C8                    INY                            ;
0587 3FA5 BF 7A 3C FF           LDA   >volsizetbl+1,x          ;
0588 3FA9 97 42                 STA   [cmdbuffl],y             ;
0589 3FAB C8                    INY                            ;
0590 3FAC A9 00                 LDA   #$00                     ;
0591 3FAE 97 42                 STA   [cmdbuffl],y             ;Hi- we're always zero here
0592 3FB0 C8                    INY                            ;
0593 3FB1 2C 1E 0F              BIT   ext_flag                 ; bit 6 set if extended
0594 3FB4 50 03                 BVC   @90                      ; otherwise go away
0595 3FB6 97 42                 STA   [cmdbuffl],y             ; the volume size is four bytes
0596 3FB8 C8                    INY                            ; if extended command
0597 3FB9 BB           @90      TYX                            ; save byte count
0598 3FBA A0 00        STAT_EXIT LDY   #$00                    ; reset high byte of byte count
0599 3FBC 24 5F                 BIT   stsmotor                 ;should I reset drive timer?
0600 3FBE 30 03                 BMI   @100                     ;no
0601 3FC0 9C 31 C0              STZ   diskreg                  ; disable drive timer by DEasserting /ENBL35 
0602 3FC3 60           @100     RTS                            ;before Deselect in mainline
0603 3FC4              ;
0604 3FC4              ;
0605 3FC4                                                      ; SEG	code
0606 3FC4              STATMASKS EQU   *                       ; status bits for wrprot, dip, swap
0607 3FC4                                                      ; SEG	fake_it
0608 3FC4 01 10 04              DC B:SVMASK3,SVMASK1,SVMASK2
0609 3FC7              ;
0610 3FC7              ;
0611 3FC7                       TITLE 'Read or Write a Block'
0612 3FC7              ************************************************************
0613 3FC7              *                                                          *
0614 3FC7              * readBlk, writeBlk           Block read and write         *
0615 3FC7              *                                                          *
0616 3FC7              *   This is the top level read/write routine.  It maps     *
0617 3FC7              *  the block number to cyl, sect, side, and proceeds to    *
0618 3FC7              *  attempt to read or write the requested block.  Up to 4  *
0619 3FC7              *  reseeks and 200 retries on address and data errors are  *
0620 3FC7              *  performed.  A recal and reseek is done after the 100th  *
0621 3FC7              *  retry.                                                  *
0622 3FC7              *                                                          *
0623 3FC7              *   Uses:    blkmap, rdaddr, read, write, seek, & recal    *
0624 3FC7              *   Input:   blocknol, blocknoh, cmdcode, drive            *
0625 3FC7              *   Output:  C <- set if a fatal error                     *
0626 3FC7              *                 clr ow                                   *
0627 3FC7              *            error2 <- bits set if error (soft or hard)    *
0628 3FC7              *                                                          *
0629 3FC7              ************************************************************
0630 3FC7              READBLK  EQU   *
0631 3FC7 18                    CLC   
0632 3FC8 80 1C                 BRA   RdWr
0633 3FCA              *
0634 3FCA              WRITEBLK EQU   *
0635 3FCA              *
0636 3FCA              * do the checksum prepass on the data
0637 3FCA              *
0638 3FCA A2 AF                 LDX   #175                     ;
0639 3FCC A0 00                 LDY   #$00                     ; assume a mac write call
0640 3FCE AD 51 0F              LDA   mac_flag                 ; check for mac write cmd
0641 3FD1 D0 0F                 BNE   write_entry              ;
0642 3FD3 A0 04                 LDY   #$04                     ; Can't be right all the time!
0643 3FD5              ZAP_LOOP EQU   *                        ;
0644 3FD5 9E 00 0C              STZ   buf1,x                   ; 4 bytes each buffer
0645 3FD8 9E 00 0D              STZ   buf2,x                   ;
0646 3FDB 9E 00 0E              STZ   buf3,x                   ;
0647 3FDE CA                    DEX                            ;
0648 3FDF 88                    DEY                            ; decrement count
0649 3FE0 D0 F3                 BNE   zap_loop                 ; when all done, then prepare the data
0650 3FE2              WRITE_ENTRY EQU   *                     ;
0651 3FE2 20 B2 4F              JSR   writeprep                ; split data & generate cksum
0652 3FE5              *
0653 3FE5              * Check for DIP, DSW and WRPROT 
0654 3FE5              *    
0655 3FE5 38                    SEC   
0656 3FE6              RDWR     EQU   *
0657 3FE6 20 05 4A              JSR   SensnChk                 ;enable,Sense, and chk volsts
0658 3FE9 B0 07                 BCS   @05                      ; some error: Offline,DSWerr,WPerr
0659 3FEB 10 09                 BPL   @CHK_BLK                 ;no need to mount volume
0660 3FED 20 68 47              JSR   MountVol                 ;online after switch or unknown voltyp
0661 3FF0 90 04                 BCC   @CHK_BLK                 ;mount worked!
0662 3FF2 8D 4B 0F     @05      STA   statbyte                 ;record error code
0663 3FF5 60           @rtn     RTS                            ; something happened go away
0664 3FF6              *
0665 3FF6              * Check block number; map to side, cylinder, sector
0666 3FF6              *
0667 3FF6 20 6A 4B     @CHK_BLK JSR   blockchk
0668 3FF9 B0 FA                 BCS   @rtn                     ;
0669 3FFB
0670 3FFB              *
0671 3FFB              * Now translate the blocknum into cyl, side, sect
0672 3FFB 20 9D 4A              JSR   blkmap
0673 3FFE              *
0674 3FFE              * Now determine if direct read can be used
0675 3FFE A5 45                 LDA   cmdcode
0676 4000 C9 01                 CMP   #cmdread
0677 4002 D0 06                 BNE   @10
0678 4004 20 AA 40              JSR   FastBufr                 ;determine if buffer is in fast memory
0679 4007 AE 28 0F              LDX   drive
0680 400A              @10      EQU   *
0681 400A              *
0682 400A              * Set up the maximum number of retries and reseeks
0683 400A              *
0684 400A A9 04                 LDA   #maxseeks
0685 400C 8D 35 0F              STA   seekret
0686 400F              *
0687 400F A9 96                 LDA   #maxret
0688 4011 8D 37 0F              STA   readret                  ;Set sector counter
0689 4014              *
0690 4014              * Now turn on the drive motor BUT set FDHD MFM/GCR mode before a motor turn-on
0691 4014 20 47 49              JSR   MotorOn                  ;
0692 4017              *
0693 4017              * Check if we have reseeked enough to recal...
0694 4017              *
0695 4017              MORESEEK EQU   *
0696 4017 AD 35 0F              LDA   seekret
0697 401A C9 02                 CMP   #skrclthrsh
0698 401C D0 03                 BNE   aseek                    ;If not two reseeks, no recal 
0699 401E              *
0700 401E              * Do a recal before seeking
0701 401E              *
0702 401E              ARECAL   EQU   *
0703 401E 20 82 48              JSR   recal
0704 4021              *
0705 4021              * Seek to the cylinder in cyl
0706 4021              *
0707 4021              ASEEK    EQU   *
0708 4021 20 26 48              JSR   seek
0709 4024 90 1B                 BCC   grabheadr                ;If no error, get an adr field 
0710 4026              OOPSEEK  EQU   *
0711 4026              *
0712 4026              * There was a seek error ("hard" or "soft"). Maintain seek counter
0713 4026              *
0714 4026 CE 35 0F              DEC   seekret
0715 4029 D0 EC                 BNE   moreseek                 ;Maybe try a reseek 
0716 402B F0 08                 BEQ   rdwrerr                  ;OW give up 
0717 402D              *
0718 402D              * Maintain the retry counter.  Quit if too many errors
0719 402D              *
0720 402D              TRYMORE  EQU   *
0721 402D EE 45 0F              INC   retry                    ;Keep status table informed
0722 4030 CE 37 0F              DEC   readret
0723 4033 D0 05                 BNE   rwckrc
0724 4035              *
0725 4035              * Set the fatal error flag
0726 4035              *
0727 4035              RDWRERR  EQU   *
0728 4035 A9 27                 LDA   #ioerror
0729 4037 82 35 FC     GOSETERR BRL   set_err                  ;
0730 403A              *
0731 403A              * If the recal threshold is reached, recal the drive.
0732 403A              *
0733 403A AD 37 0F     RWCKRC   LDA   readret
0734 403D C9 4B                 CMP   #rclthresh
0735 403F F0 DD                 BEQ   arecal
0736 4041              *
0737 4041              * Okay, read an address field
0738 4041              *
0739 4041              GRABHEADR EQU   *
0740 4041 20 4F 4C              JSR   rdaddr
0741 4044 90 0D                 BCC   sidesokay
0742 4046 24 5A                 BIT   temp                     ;read adrs get CS/BS error?
0743 4048 10 E3                 BPL   trymore                  ;yes.
0744 404A 50 EB                 BVC   goseterr                 ;offline ?!!? error in RdAddrs
0745 404C CE 37 0F              DEC   readret                  ;timeout err uses 
0746 404F D0 DC                 BNE   trymore                  ;double the retries
0747 4051 80 E2                 BRA   rdwrerr
0748 4053              *
0749 4053              * Now, see if this is the cylinder we expected 
0750 4053              *
0751 4053              SIDESOKAY EQU   *
0752 4053 AD 32 0F              LDA   sidefnd
0753 4056 85 5A                 STA   temp
0754 4058 AD 34 0F              LDA   trkfnd
0755 405B 0A                    ASL   a
0756 405C 0A                    ASL   a
0757 405D 46 5A                 LSR   temp
0758 405F 6A                    ROR   a
0759 4060 4A                    LSR   a
0760 4061 CD 29 0F     @cmpCYL  CMP   cyl
0761 4064 F0 0D                 BEQ   rightcyl
0762 4066              *
0763 4066              * Well, we seeked (sucked?) to the wrong cylinder.  Use the cylinder
0764 4066              *  number found to define our current position. 
0765 4066              *
0766 4066 AE 28 0F              LDX   drive
0767 4069 9D 3A 0F              STA   curcyl,x                 ;Use cyl found as reference
0768 406C A9 04                 LDA   #sftskerror              ;Flip on seek error bit
0769 406E 0C 44 0F              TSB   error2
0770 4071 80 B3                 BRA   oopseek                  ;One more seek error and retry
0771 4073              *
0772 4073              * Is side found what we thought?
0773 4073              *
0774 4073              RIGHTCYL EQU   *
0775 4073 A5 5A                 LDA   temp
0776 4075 0A                    ASL   a
0777 4076 0A                    ASL   a
0778 4077 0A                    ASL   a
0779 4078 4D 2B 0F              EOR   side
0780 407B 30 B0                 BMI   trymore                  ;Treat as a soft error
0781 407D              *
0782 407D              * If this is the right sector, we win!
0783 407D              *
0784 407D              RIGHTSIDE EQU   *
0785 407D AD 33 0F              LDA   sectfnd
0786 4080 CD 2A 0F              CMP   sector
0787 4083 D0 A8                 BNE   trymore                  ;Keep looking
0788 4085              *
0789 4085              * Found the target, now do whatever we came to do (read or write)
0790 4085              *
0791 4085 A5 45                 LDA   cmdcode
0792 4087 C9 02                 CMP   #cmdwrite
0793 4089 F0 1A                 BEQ   dowrite                  ;Assume write if not read
0794 408B              *
0795 408B              * Try to read the data field
0796 408B              *
0797 408B 20 D9 4C     @33      JSR   ReadData                 ;read direct/indirect 
0798 408E B0 9D                 BCS   trymore
0799 4090 2C 42 0F              BIT   DRswtch                  ;was a Direct Read done?
0800 4093 30 03                 BMI   sbset                    ;yep. don't need MergeIt
0801 4095              *
0802 4095              * Got the data - send it over
0803 4095              *
0804 4095 20 EB 50              JSR   MergeIt                  ;Move data to user buffer
0805 4098              *
0806 4098              SBSET    EQU   *
0807 4098 18                    CLC                            ; assume no errors
0808 4099 AD 44 0F              LDA   error2
0809 409C F0 05                 BEQ   skipstow
0810 409E A9 67                 LDA   #SoftError
0811 40A0 82 CC FB              BRL   set_err                  ; mark an error
0812 40A3              SKIPSTOW EQU   *
0813 40A3 18                    CLC                            ; no errors
0814 40A4 60                    RTS   
0815 40A5              *
0816 40A5              * Write out a data field
0817 40A5              *
0818 40A5              DOWRITE  EQU   *
0819 40A5 20 2C 50              JSR   WriteData
0820 40A8 18                    CLC   
0821 40A9 60                    RTS   
0822 40AA                       EJECT 
0823 40AA              **************************************************
0824 40AA              * FastBufr
0825 40AA              *
0826 40AA              * FastBufr determines if the user buffer address
0827 40AA              * is in fast memory or if the 512 bytes spans a
0828 40AA              * bank boundary
0829 40AA              *
0830 40AA              *    INPUT :  cmdbuffl+1,+2 is user buffer adrs
0831 40AA              *    OUTPUT: DRswtch =  00 if bk spanned or slow (shadowed)
0832 40AA              *            DRswtch = $FF if fast and not bk spanned 
0833 40AA              *
0834 40AA              ***************************************************
0835 40AA              FASTBUFR EQU   *
0836 40AA 9C 42 0F              STZ   DRswtch                  ;assume slow &/ bk spanned
0837 40AD 2C 51 0F              BIT   mac_flag                 ;524 rd? 
0838 40B0 30 32                 BMI   @slow                    ;must use slow
0839 40B2 A4 44                 LDY   cmdbuffl+2
0840 40B4 C0 E0                 CPY   #$E0
0841 40B6 90 04                 BCC   @10
0842 40B8 C0 E2                 CPY   #$E1+1
0843 40BA 90 28                 BCC   @slow
0844 40BC C0 02        @10      CPY   #02
0845 40BE 90 08                 BCC   @15
0846 40C0 A6 43                 LDX   cmdbuffl+1
0847 40C2 E0 FF                 CPX   #$FF
0848 40C4 D0 1B                 BNE   @fast
0849 40C6 80 1C                 BRA   @slow
0850 40C8 AD 35 C0     @15      LDA   shadow
0851 40CB 29 1E                 AND   #$1E
0852 40CD C9 1E                 CMP   #$1E                     ;all fast?
0853 40CF F0 10                 BEQ   @fast
0854 40D1 A6 43                 LDX   cmdbuffl+1
0855 40D3 20 E5 40              JSR   chkpgslow
0856 40D6 B0 0C                 BCS   @slow
0857 40D8 A6 43                 LDX   cmdbuffl+1
0858 40DA E8                    INX   
0859 40DB E8                    INX   
0860 40DC 20 E5 40              JSR   chkpgslow
0861 40DF B0 03                 BCS   @slow
0862 40E1 CE 42 0F     @FAST    DEC   DRswtch
0863 40E4 60           @SLOW    RTS   
0864 40E5              **************************************
0865 40E5              * ChkpgSlow checks the page address
0866 40E5              * of a page in bank 0/1 to see
0867 40E5              * if it is shadowed and therefore slow
0868 40E5              *
0869 40E5              * INPUTS :  X = page address to check
0870 40E5              *           A = shadow Reg shadow bits
0871 40E5              *               (Shadow AND $1E)
0872 40E5              *           Y = Bank address (00/01)
0873 40E5              * OUTPUT :  C = 1 if slow
0874 40E5              *           C = 0 if fast    
0875 40E5              *
0876 40E5              * PRESERVES : A-reg, X-reg, Y-reg
0877 40E5              * DESTROYS  : carry  (and P)
0878 40E5              ***************************************
0879 40E5              CHKPGSLOW EQU   *
0880 40E5 E0 FF                 CPX   #$FF                     ;do bufr pags span bank boundary?
0881 40E7 F0 38                 BEQ   @slow                    ;yes. so do block indirect!
0882 40E9 E0 D0                 CPX   #$D0
0883 40EB B0 32                 BCS   @fast
0884 40ED E0 C0                 CPX   #$C0
0885 40EF B0 30                 BCS   @slow
0886 40F1 E0 A0                 CPX   #$A0
0887 40F3 B0 2A                 BCS   @fast
0888 40F5 E0 0C                 CPX   #$0C                     ;foget the txtpg2 buffer too!
0889 40F7 90 28                 BCC   @slow
0890 40F9 C0 01                 CPY   #01                      ;bank 1 only check?
0891 40FB D0 0A                 BNE   @20
0892 40FD E0 60                 CPX   #$60
0893 40FF 90 06                 BCC   @20                      ;adrs not in range
0894 4101 24 08                 BIT   %00001000                ;is $6000..$9FFF fast RAM
0895 4103 D0 1A                 BNE   @fast                    ;yep
0896 4105 80 1A                 BRA   @slow
0897 4107 E0 20        @20      CPX   #$20                     ;in hires 1/2 range?
0898 4109 90 14                 BCC   @fast                    ;no.
0899 410B E0 40                 CPX   #$40                     ;hires 1 or 2?
0900 410D B0 04                 BCS   @30
0901 410F 89 02                 BIT   #%00000010               ;are HiRes1,1X both fast?
0902 4111 80 02                 BRA   @35
0903 4113 89 04        @30      BIT   #%00000100               ;is HiRes2,2x both fast?
0904 4115 D0 08        @35      BNE   @fast
0905 4117 C0 00                 CPY   #00
0906 4119 F0 06                 BEQ   @slow                    ;
0907 411B 89 10                 BIT   #%00010000               ;is HiRes1x or 2x fast 
0908 411D F0 02                 BEQ   @slow                    ;no.
0909 411F 18           @FAST    CLC   
0910 4120 60                    RTS   
0911 4121 38           @SLOW    SEC   
0912 4122 60                    RTS   
